/** Die Klasse GRStaff ist ein Graphisches Objekt, dass vom StaffManager
  * erstellt und verwaltet wird.
  * Abgeleitet von GRCompositeNotationElement enthaelt es NotationElemente
  * (die zeitlich sortiert sind).
  * GRStaffs werden von GRSystem gezeichnet und "besessen".
  */
/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grstaff.cpp,v 1.7 2002-10-29 10:38:49+01 renz Exp $ 

$Id: grstaff.cpp,v 1.7 2002-10-29 10:38:49+01 renz Exp $ 

$Log: grstaff.cpp,v $
Revision 1.7  2002-10-29 10:38:49+01  renz
addFinishBar is now done to SystemSlice (instead of system as it was way before)

Revision 1.6  2002-09-09 13:29:24+02  renz
boundingRectangle.bottom now calculated correctly.

Revision 1.5  2002-08-29 11:38:32+02  renz
Added RCS Headers
GRStaff has to deal with SystemSlices now
The drawing-aspect has changed because of that
Lots of previously used functions are now obsolete
 

$Author: renz $ 

$Date: 2002-10-29 10:38:49+01 $ 

$Locker:  $ 

$Revision: 1.7 $ 

$Name:  $ 

$RCSfile: grstaff.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grstaff.cpp,v $ 

*/

#include <typeinfo>
#include <stdlib.h>

#include "parser\guido.h"

#include "AbstrctR\AbstrctO\ARMeter.h"
#include "AbstrctR\AbstrctO\AROctava.h"
#include "AbstrctR\AbstrctO\ARRpBeg.h"
#include "AbstrctR\AbstrctO\ARRpEnd.h"
#include "AbstrctR\AbstrctO\ARRpEnRe.h"
#include "AbstrctR\AbstrctO\ARNKey.h"
#include "AbstrctR\AbstrctO\ARFBar.h"
#include "GrphclRp\GrphclOb\GRNote.h"
#include "GrphclRp\GrphclOb\GRRod.h"
#include "AbstrctR\AbstrctO\ARBarFrm.h"
#include "AbstrctR\AbstrctO\ARInstr.h"


// Class GRCompositeNote
#include "GrphclRp\GrphclOb\GRCmpNot.h"

#include "GrphclRp\GrphclOb\GRSngNot.h"
#include "GrphclRp\GrphclOb\GRClef.h"
#include "GrphclRp\GrphclOb\GRMeter.h"
#include "GrphclRp\GrphclOb\GRTakStr.h"
#include "GrphclRp\GrphclOb\GRDBar.h"
#include "GrphclRp\GrphclOb\GRRest.h"
// #include "GrphclRp\GrphclOb\GRTie.h" 
// #include "GrphclRp\GrphclOb\GRSlur.h"
#include "GrphclRp\GrphclOb\GRCresc.h"
#include "GrphclRp\GrphclOb\GRNFacto.h"
#include "GrphclRp\GrphclOb\GRTuplet.h"
#include "GrphclRp\GrphclOb\GRChord.h"
#include "GrphclRp\GrphclOb\GRKey.h"
#include "GrphclRp\GrphclOb\GRText.h"
#include "GrphclRp\GrphclOb\GRSText.h"
#include "GrphclRp\GrphclOb\GRIntens.h"
#include "GrphclRp\GrphclOb\GRFerm.h"
#include "GrphclRp\GrphclOb\GRSystem.h"
#include "GrphclRp\GrphclOb\GRGlue.h"
#include "GrphclRp\GrphclOb\GRStafMg.h"
#include "GrphclRp\GrphclOb\GRRod.h"
#include "GrphclRp\GrphclOb\GRRpBeg.h"
#include "GrphclRp\GrphclOb\GRRpEnd.h"
#include "GrphclRp\GrphclOb\GRSpace.h"
#include "GrphclRp\GrphclOb\GRStem.h"

#include "GrphclRp\GrphclOb\GRMusic.h"

// GRStaff
#include "GrphclRp\GrphclOb\GRStaff.h"
#include "GrphclRp\GrphclOb\GRVoice.h"
#include "GrphclRp\GrphclOb\GRFBar.h"


#include "GrphclRp\GrphclOb\GRStfrmt.h"
#include "GrphclRp\GrphclOb\GRBarFrm.h"
#include "GrphclRp\GrphclOb\GRSpecil.h"
#include "GrphclRp\GrphclOb\GRDummy.h"
#include "GrphclRp\GrphclOb\GRInstr.h"
#include "GrphclRp\GrphclOb\GRSysSlc.h"



#include "GRphclRp\GrphclOb\grdefine.h" // fuer LSPACE

#include "nview.h" // fuer den Font (scriabin)

#include "kf_ilist.h"

typedef KF_IPointerList<GRNotationElement> GRList;

// new constructor ...
GRStaff::GRStaff(GRSystemSlice *systemslice)
	 : GRCompositeNotationElement(),
	    grsystemslice(systemslice), grsystem(NULL)
{
	length = 0;

	relativeTimePositionOfGR = systemslice->getRelativeTimePosition();
	
	durationOfGR = DURATION_0;

	setClefParameters(NULL);
	setMeterParameters(NULL);
	setKeyParameters(NULL);

	startglue = 
	endglue = 
	secglue = NULL;

	lastrod = NULL;
	firstrod = NULL;

	// obsolete
	// spacing = 0;

//	lastmeasurepos = 0;
}

/* 
// old constructor ...
GRStaff::GRStaff(GRSystem *system,
	TYPE_TIMEPOSITION relativeTimePositionOfStaff,
	TYPE_DURATION durationOfStaff)
	 : GRCompositeNotationElement(),
	    grsystem(system)
{
	relativeTimePositionOfGR = relativeTimePositionOfStaff;
	durationOfGR = DURATION_0;

	setClefParameters(NULL);
	setMeterParameters(NULL);
	setKeyParameters(NULL);

	startglue = 
	endglue = 
	secglue = NULL;

	lastrod = NULL;
	firstrod = NULL;

	// obsolete
	// spacing = 0;

//	lastmeasurepos = 0;
}
*/

GRStaff::~GRStaff()
{

	// this routine has been done in this fashion,
	// because that way, the associations are
	// done correctly ....
	// but who deletes the Events? and the Glue ?
	POSITION pos = elements->GetHeadPosition();
	while (pos)
	{
		POSITION curpos = pos;
		GRNotationElement *el = elements->GetNext(pos);

		if (!dynamic_cast<GREvent *>(el)
			&& !dynamic_cast<GRGlue *>(el))
		{
			GRDummy *grdum = dynamic_cast<GRDummy *>(el);
			GRPositionTag *ptag = dynamic_cast<GRPositionTag *>(el);
			if (ptag)
			{

				if (!ptag->DeleteStaff(this))
				{
					elements->setOwnership(0);
					elements->RemoveElementAt(curpos);
					elements->setOwnership(1);
				}
				else
					elements->RemoveElementAt(curpos);
			}
			else if (grdum)
			{
				// it is a dummy (stands for a position tag ...)
				ptag = grdum->getPositionTag();
				if (ptag)
				{
					// if ptag->DeleteStaff returns 1, then
					// the sse-list inside the position tag 
					// is empty, then the whole tag MUST be 
					// deleted.
					// The reason, why this needs to be done here
					// is that systems are deleted from the beginning
					// towards the end: the original positionTag in
					// the previous system has had DeleteStaff called
					// for the previous staff. 
					if (ptag->DeleteStaff(this))
					{
						delete ptag;
					}
				}
				elements->RemoveElementAt(curpos);
			}
			else
				elements->RemoveElementAt(curpos);
		}
	}
	
}

void GRStaff::GGSOutput() const
{
	char buffer[200];
	ASSERT(endglue);
	sprintf(buffer,"\\draw_staff<%ld,%d,%ld,%ld,%ld>\n",
		gid,
		mystate.numlines,
		position.x + ggsoffsetx,
		position.y + 4*LSPACE + ggsoffsety,
		endglue->getPosition().x);
		// position.x + boundingRectangle.right);

	AddGGSOutput(buffer);

	ggsoffsetx += position.x;
	ggsoffsety += position.y;

	GRNotationElement* e;
	POSITION pos=elements->GetHeadPosition();
	while (pos)
	{
		e=elements->GetNext(pos);
		e->GGSOutput();
	}

	ggsoffsetx -= position.x;
	ggsoffsety -= position.y;
}

void GRStaff::OnDraw(HDC hdc) const
{
	// Hier numlines Notenzeilen ...
	NVPoint point = getPosition();

	// here we need to get the correct size of the font ...
	// if (error) return;
	HFONT myfont = hfontscriab;
	float fontsize = getFontSize();
	const short * colref = getColRef();
//	const NVPoint & offset = getOffset();

		myfont = GRSpecial::getFont(
			(long) fontsize,
			NULL,NULL,0);
	

    HFONT hfontold = (HFONT) SelectObject(hdc,myfont);

	// save old hdc
	// HFONT hfontold=(HFONT) SelectObject(hdc, hfontscriab);

	PS_SELECTSCRIABIN
	int nBackmode=GetBkMode(hdc);
	UINT ta=GetTextAlign(hdc);
	SetBkMode(hdc, TRANSPARENT);
	SetTextAlign(hdc, TA_LEFT | TA_BASELINE);

	char zeichen=(char)STAFFCHAR;
#ifndef __FLAT__
	WORD staffcharlen=LOWORD(GetTextExtent(hdc,&zeichen,1));
#else
	SIZE mysize;
	GetTextExtentPoint32(hdc,&zeichen,1,&mysize);
	WORD staffcharlen = mysize.cx;
#endif


	// ASSERT(endglue);
	// MoveToEx(hdc,point.x,point.y-45,NULL);
	//LineTo(hdc,point.x + endglue->getPosition().x,
	//	point.y - 45);

	// have to work on that!!!
	WORD lineToX= point.x + length;
		// endglue->getPosition().x;
	// lineToX = point.x+getSizeX();

	for (UINT posx=point.x; posx<lineToX; posx+=staffcharlen) {

		int ende = 0;
		if (posx + staffcharlen> lineToX)
		{
			if (lineToX >= (staffcharlen+2))
				posx = lineToX - staffcharlen - 2;
			else 
				posx = point.x;
			ende = 1;
		}
		

		int diffx = -1;
		if (posx == point.x)
			diffx = 0;
		if (mystate.numlines == 5)
		{

			
			TextOut(hdc,posx+diffx,point.y+4*getStaffLSPACE(),&zeichen,1);

			PS_DRAWCHAR(posx+diffx,point.y+4*LSPACE,zeichen);
		}
		else
		{
			// we have to draw the staff with a different sign ...
			for (int i=0;i<mystate.numlines;i++)
			{
				unsigned int tmptype = 89;
				TextOut(hdc,posx,point.y+i*getStaffLSPACE(),(const char* ) 
					&tmptype,1);
			}
		}
	
		if (ende)
			break;
	}




	// restore old hdc
	SetTextAlign(hdc, ta);
	SetBkMode(hdc, nBackmode);
	SelectObject(hdc, hfontold);

// hier das gleiche mit LineTo's
/*
	int incy = 0;
	for (int i=0;i<mystate.numlines;i++,incy+=LSPACE) {
#ifndef __FLAT__
	 MoveTo(hdc,point.x,point.y+incy);
#else
	 MoveToEx(hdc,point.x,point.y+incy,NULL);
#endif
	 // Es tritt manchmal ein seltsamer Fehler auf ...
	 // dabei werden die Linien nicht gezeichnet (nur unter WinNT)
	 long tmp = point.x + getSizeX();
	 LineTo(hdc,tmp,point.y+incy);
	}
*/



/* Holger meint, es sollte offen sein.
	// Strich am Anfang
#ifndef __FLAT__
	MoveTo(hdc,position.x,position.y);
#else
	MoveToEx(hdc,position.x,position.y,NULL);
#endif

	LineTo(hdc,position.x,position.y+(mystate.numlines-1)*LSPACE);
*/

	// Koordinatensystem liegt am Anfang der Notenzeile
#ifndef __FLAT__
	OffsetWindowOrg(hdc,-position.x,-position.y);
#else
	POINT mypt;
	GetWindowOrgEx(hdc,&mypt);
	OffsetWindowOrgEx(hdc,0, // -position.x,
		-position.y,NULL);
	GetWindowOrgEx(hdc,&mypt);
#endif

	PS_TRANSLATE(-position.x,-position.y)


	GRNotationElement* e;
	POSITION pos=elements->GetHeadPosition();
	while (pos)
	  {
		e=elements->GetNext(pos);
		e->OnDraw(hdc);
/*		if (  position.x + e->getBoundingRectangle().left + e->getPosition().x >
			cliprect.right)
			break; */
		}
/*	while(pos &&
		(elements->GetAt(pos)->getRelativeTimePosition()<getRelativeEndTimePosition()
		|| (elements->GetAt(pos)->getRelativeTimePosition()==getRelativeEndTimePosition()
			 && elements->GetAt(pos)->getDuration() == DURATION_0 ) ) )
	{
		e=elements->GetNext(pos);
		e->OnDraw(hdc);
		if (  position.x + e->getBoundingRectangle().left + e->getPosition().x >
			cliprect.right)
			break;
	} */

//	Rectangle(hdc,boundingRectangle.left,boundingRectangle.top,boundingRectangle.right,
//		boundingRectangle.bottom);

#ifndef __FLAT__
	OffsetWindowOrg(hdc,position.x,position.y);
#else
	OffsetWindowOrgEx(hdc,0, // position.x,
		position.y,NULL);
#endif
	PS_TRANSLATE(position.x,position.y)

}

/* Liefert eine Liste mit Elementen an der Zeitposition
	timeposition.
*/

/*
NEPointerList* GRStaff::getElementsAtTimeposition(TYPE_TIMEPOSITION
			timeposition)
{
	ASSERT(timeposition>=relativeTimePositionOfGR);

	// ACHTUNG, ATTENTION wann passiert das (duration der
   // Systeme wird geaendert ... ? )
	//	ASSERT(timeposition<=getRelativeEndTimePosition());

	NEPointerList* list=new NEPointerList;
	GRNotationElement* e=NULL;
	TYPE_TIMEPOSITION start = DURATION_0;
	TYPE_TIMEPOSITION end   = DURATION_0;
	POSITION pos=elements->GetHeadPosition();
	while(pos && start<=timeposition)
	{
		e=elements->GetNext(pos);
		start=e->getRelativeTimePosition();
		// das ist Mutig, denn getRelativeEndTimePosition ist fuer
		// GRNotationElement eigentlich mit ASSERT(FALSE) belegt.
		// Scheint aber zu funktionieren -> es werden wohl nur
		// bestimmte Elemente in den Staffs abgelegt (d.h. die Funktion
		// ist dann immer definiert!?)
		end=e->getRelativeEndTimePosition();
		if(start<timeposition && timeposition<end || start==timeposition)
			list->AddTail(e);
	}
	return list;
}

POSITION GRStaff::getPosAtTimeposition(TYPE_TIMEPOSITION timeposition)
{
	ASSERT(timeposition>=relativeTimePositionOfGR);
	ASSERT(timeposition<=getRelativeEndTimePosition());
	if(timeposition>=getDuration())
	{
		return NULL; // timeposition ist ausserhalb Staff...
//		ASSERT(FALSE);// ...duerfte wegen ASSERTs aber nicht passieren!
	}
	GRNotationElement* e;
	POSITION pos=elements->GetTailPosition();
	while(pos)
	{
		e=elements->GetAt(pos);
		if(e->getRelativeTimePosition()<=timeposition)
			return pos; // liefert Listenposition des Elements das an timeposition zu hoeren ist
		elements->GetPrev(pos);
	}
	return NULL;
}
*/

/*void GRStaff::setNoSpacing()
{
	GRNotationElement* e;
	CPoint point;
	point.x = 0;
	point.y = 0;
	POSITION pos=elements->GetHeadPosition();
	while(pos)
	{
		e=elements->GetNext(pos);
		// setPosition veraendert point!
		e->setPosition(point);
		e->setSpacing(0);
	}
	boundingRectangle.left = 0;
	boundingRectangle.top = 0;
	boundingRectangle.right = 0;
	boundingRectangle.bottom = 0;
	nextElementPosition.x = LSPACE;
	nextElementPosition.y = 0;
  //## end GRStaff::setNoSpacing%852145361.body
}
*/

void GRStaff::print() const
{
	GRNotationElement* e;
	fprintf(stderr,"GRStaff::print(): %.2f-%.2f ",
		(float) relativeTimePositionOfGR, (float) getRelativeEndTimePosition());
	POSITION pos=elements->GetHeadPosition();
	while(pos)
	{
		e=elements->GetNext(pos);
		e->print();
	}
	fprintf(stderr,"\n");
}

/* void GRStaff::addNotationElementNoTime(
			  GRNotationElement * notationElement)
{
	ASSERT(notationElement);
	elements->AddTail(notationElement);
} */

// Fuegt das NotationElement in den Staff ein. Dabei wird auf
// die korrekte Position innerhalb des Zeitframes geachtet.

// ACHTUNG, hier kann man jede Menge Zeit einsparen.
// Frage: Braucht man hier ueberhautp eine Zeitbetrachtung
// eigentlich ist die graphische Ebene "Zeitlos". Zumindest
// wenn man rein graphische Elemente betrachtet!

void GRStaff::addNotationElement(GRNotationElement* notationElement)
{

	ASSERT(notationElement);

	// this time, the time-check is disabled, if
	// we have a positiontag (because those are
	// added some more times than just once!)
	if (!dynamic_cast<GRPositionTag *>(notationElement))
	{
		
		if (elements->GetTail())
		{ 
			TYPE_TIMEPOSITION tp1 = notationElement->getRelativeTimePosition();

			// no notation element may be added to the staff, that
			// is EARLIER than the staff itself.
#ifdef DEBUG
			ASSERT(tp1>=getRelativeTimePosition());
#endif
			
			/*		notationElement->setHPosition(curposx);
			if (notationElement->hasExtent())
			curposx = notationElement->getPosition().x
			+ notationElement->getSpacing()
			+ notationElement->getBoundingRectangle().right; */
			
			TYPE_TIMEPOSITION tp2 = elements->GetTail()->getRelativeTimePosition();
			if (tp1<tp2)
			{
				ASSERT(FALSE);
				elements->AddAtCorrectTimePosition(notationElement);
			}
			else
				elements->AddTail(notationElement);
		}
		else
			elements->AddTail(notationElement);
	}
	else
		elements->AddTail(notationElement);


	// this should sort the elements ...
	// it is no longer needed; sorting is done
	// on the abstract representation, and all
	// elements are added/sorted there.
	//if (sortElements)
	//	elements->sort( & GRNotationElement::comp);

	// This is old, horizontal synchronisation
	// is done by StaffManager and not longer
	// by the System:
	
	// This is done, so that all Elements that are added
	// are subject to vertical-slice-spacing right after
	// the current time slice has been worked upon.
	// OLD: grsystem->AddToSpace(notationElement);

	GRNote *mynote = dynamic_cast<GRNote *>(notationElement);
	if (mynote)
	{
		// zaehlt die Noten,
		// behandelt Vorzeichen 
		setNoteParameters(mynote);
	}
	
}

// Routine, die nach dem Fuellen des Staffs aufgerufen wird.
// Hier muessen die einzelnen musikalischen Elemente ihre Position
// ueberpruefen ... Kollisionen muessen vermieden werden ...
// diese Routine muss von GRSystem aufgerufen werden; denkbar
// ist das gegeneinanderverschieben von Noten (noten mit gleicher
// Laenge und unterschiedlichen Koepfen, bzw. Noten nebeneinander!)
// Vorzeichenkollosion muss auch vermieden werden!
/* void GRStaff::recalcPositions(void)
{
	// Initialisierung ....
	nextElementPosition.x = LSPACE;

	NVPoint tmp = nextElementPosition;
	GRNotationElement *e;
	POSITION pos = elements->GetHeadPosition();
	TYPE_TIMEPOSITION oldtp = elements->GetHead()->getRelativeTimePosition();
	while (pos)
		{
			e = elements->GetNext(pos);
			if (e->getDuration() == DURATION_0)
				nextElementPosition = tmp;
			  else if (e->getRelativeTimePosition()> oldtp)
				nextElementPosition = tmp;

			tmp = nextElementPosition;
			e->setHPosition(tmp.x);
		}
}
*/
/* int GRStaff::getStandardSpacing() const
{
	return LSPACE/2; // vorerst mal... spter ber Layouts!
} */

/* void GRStaff::setHorizontalStandardSpacing()
{
	GRNotationElement* e;
	POSITION pos=elements->GetHeadPosition();
	int px = LSPACE;
	while(pos)
	{
		e=elements->GetNext(pos);
		e->setHPosition(px);
		e->setSpacing(e->getSpacing());
		px +=  e->getSpacing()+e->getSizeX();
	}
	updateBoundingRectangle();
} */

void GRStaff::updateBoundingRectangle()
{
  boundingRectangle.left = 0;
  boundingRectangle.top = 0;
  boundingRectangle.right = 0;
  // ACHTUNG, hier eigentlich numlines!?
  boundingRectangle.bottom= (mystate.numlines-1) * getStaffLSPACE();

  // Schleife ueber alle Elemente ...
  GRNotationElement *e;
  POSITION pos = elements->GetHeadPosition();
  while (pos)
	 {
	 e = elements->GetNext(pos);
	 NVRect b = e->getBoundingRectangle();
	 NVPoint p = e->getPosition();

	 // In diesem fall wird position nicht verwendet, weil
	 // alle Elemente des Staffs RELATIV zum Staff positioniert
	 // sind (keine absoluten Positionsangaben!)
	 if (p.x + b.right > boundingRectangle.right)
		boundingRectangle.right = p.x + b.right;
	 if (p.x + b.left < boundingRectangle.left)
		boundingRectangle.left = p.x + b.left ;
	 if (p.y + b.top < boundingRectangle.top)
		boundingRectangle.top = p.y + b.top ;
	 if (p.y + b.bottom > boundingRectangle.bottom)
		boundingRectangle.bottom = p.y + b.bottom ;
	 }
} // updateBoundingRectangle

/* I dont need this function any more!
GRNote* GRStaff::createCutStaffElement(
	ARMusicalObject* arOfCompleteObject,
	const TYPE_TIMEPOSITION relativeTimePositionOfCut,
	const TYPE_DURATION durationOfCut,
	GRNoteFactory *grnotefactory)
{
	ASSERT(arOfCompleteObject);
	ASSERT(relativeTimePositionOfCut>=
			arOfCompleteObject->getRelativeTimePosition());
	ASSERT(relativeTimePositionOfCut+durationOfCut
			<=arOfCompleteObject->getRelativeEndTimePosition());

	//	ASSERT(durationOfCut>0); // not for Clefs, Keys and all that

	ASSERT(durationOfCut<=arOfCompleteObject->getDuration());

	// Hier wird berprft, ob BAR-Lines (Taktstriche) zu ziehen sind.
	// Das ist abhaengig, von der Momentanen Meter-Einstellung!

	GRNote *prevnote = NULL;
	GRNote *curnote = NULL;

	TYPE_DURATION dur = durationOfCut;

	// Nur noten und Pausen haben wirklich eine Laenge!
	if (dynamic_cast<ARText *>(arOfCompleteObject))
		dur = DURATION_0; // warum braucht man das?, d.h. warum
							// hat text zwischenzeitlich ueberhautpt eine Laenge?

	TYPE_DURATION von,bis;

	von = relativeTimePositionOfCut;
	int first = 1;

	// Eine Schleife so lange, bis alle einzelnen Elemente
	// berechnet sind. Abhaengig von der aktuellen Meter-Einstellung
	// (das bezieht sich auf Noten, die ueber mehrere Takte laufen und die
	// deshalb mehrere graphischen Elemente zusteht)

	do {
		// Frage: Ist waehrend der Duration ein (mehrere) Taktstich(e)
		curnote = NULL;
		von += bis;
		bis = dur;
		if (mystate.meterset == TRUE && mystate.measuretime + dur
					> mystate.measurelength)
			{
			bis = mystate.measurelength - mystate.measuretime;
			}

#ifdef __VC50__
#define __VC40_MFC
#endif

#ifdef __VC40_MFC
		const type_info& ti=typeid(*arOfCompleteObject);
#else
		const typeinfo& ti = typeid(*arOfCompleteObject);
#endif

#ifdef __VC40_MFC
		if(!strcmp(ti.name(),"class ARNote"))
#else
		if(!strcmp(ti.name(),"ARNote"))
#endif
		{
		GRNote *tmpnote = grnotefactory->createNote(
				dynamic_cast<ARNote *>(arOfCompleteObject),
				von,bis);

		if (!tmpnote)
		{
			continue;
		}

		// evtl. setNoteParameters fuer GRSingleNote ?
		if (first)
		  {
		  setNoteParameters(tmpnote);
		  }

		addNotationElement(tmpnote);


		// Verknuepfung von Graphischem Element und Abstraktem Objekt
		(dynamic_cast<ARNote *>(arOfCompleteObject))->addGRRepresentation(tmpnote);

		curnote = tmpnote;

		POSITION pos = grtags->GetHeadPosition();
		while (pos)
			{
			GRNotationElement *el = 
				dynamic_cast<GRNotationElement *>(grtags->GetNext(pos));
			if (el)
				el->addAssociation(curnote);
			}

		}
#ifdef __VC40_MFC
		else if(!strcmp(ti.name(),"class ARRest"))
#else
		else if(!strcmp(ti.name(),"ARRest"))
#endif
		{
			// Pausen der Laenge Null erzeugen nichts ...
			GRRest *tmp = grnotefactory->createRest(
				dynamic_cast<ARRest *>(arOfCompleteObject),von,bis);
			if (tmp)
				addNotationElement( tmp );

			// Verknuepfung von Graphischem Element und Abstraktem Objekt
			(dynamic_cast<ARRest *>(arOfCompleteObject))->addGRRepresentation(tmp);	

		POSITION pos = grtags->GetHeadPosition();
		while (pos)
		{
			GRNotationElement *el = 
				dynamic_cast<GRNotationElement *>(grtags->GetNext(pos));
			if (el)
				el->addAssociation(tmp);
		}
	}
	else 
		ASSERT(FALSE);

  if (first)
	{
	first = 0;
	}
  else
	{
	// Verbinde eventuell Noten mittels tie
	if (prevnote && curnote)
		{
		GRTie *tie = new GRTie();
		tie->setStartElement(prevnote);
		tie->setEndElement(curnote);
		prevnote->addAssociation(tie);
		curnote->addAssociation(tie);
		// Tie zu den Elements ????
		// das macht beim Spacing Probleme!
		elements->AddTail(tie);
		}
	}

*/
/*	if (mystate.meterset == TRUE && bis>DURATION_0)
		{
		mystate.measuretime += bis;
		mystate.measuretime %= mystate.measurelength;
		// fuegt einen Taktstrich ein, wenn noetig!
		if (mystate.measuretime == TYPE_TIMEPOSITION(0L) &&
			von+bis != TYPE_TIMEPOSITION(0L) )
			{
			// Baue einen Taktstrich ein !
			if (!dynamic_cast<GRTaktStrich *>(elements->GetTail()))
				{
				if (mystate.mnum == 0) // damit takte, die ganz am Anfang stehen
					mystate.mnum = 1; // auch richtig erkannt werden.
				newMeasure();
				GRTaktStrich *tmpts = new GRTaktStrich(new ARBar,this,von+bis,
					mystate.mnum);
				tmpts->setOwnership(1);
				addNotationElement(tmpts);
				}
			}
		  else if (mystate.measuretime == DURATION_0 && von+bis == DURATION_0)
			{
				mystate.mnum++; // damit der naechste Strich wirklich bei Zaehler
						// 2 anfaengt ...
			}
		} */
/*
	dur -= bis;

	prevnote = curnote;
  } while ( mystate.meterset == TRUE && dur > DURATION_0);

  return prevnote;

} */

#ifdef __VC50__
#undef __VC40_MFC
#endif

GRClef * GRStaff::AddClef(ARClef  *arclef)
{

	// To do: look, wether the clef really is a clef-
	// change. If not, do nothing!!!!
	GRClef *grclef = new GRClef(arclef,this);
	TYPE_TIMEPOSITION tmp = relativeTimePositionOfGR;
	GRNotationElement *el = elements->GetTail();
	if (el) 
		tmp = el->getRelativeEndTimePosition();
	grclef->setRelativeTimePosition(tmp);

	setClefParameters(grclef,GRStaffState::CLEFEXPLICIT);
	addNotationElement(grclef);
	return grclef;
}


void GRStaff::setMeterParameters(GRMeter *grmeter)
{
	mystate.meterset = FALSE;
	if ( (grmeter != NULL) && 
		(grmeter->getARMeter() != NULL) &&
		(grmeter->getARMeter()->getMeterType() != ARMeter::NONE ))
	{
		// Taktlaenge
		mystate.curmeter = grmeter->getARMeter();
		mystate.meterset = TRUE;
		ARMeter::metertype mtype = mystate.curmeter->getMeterType();
/*		if (mtype == ARMeter::C)
		{
			mystate.measurelength = TYPE_DURATION (4L,
				4L);
		}
		else if (mtype == ARMeter::C2)
		{
			mystate.measurelength = TYPE_DURATION (2L,4L);
		}
		else if (mtype == ARMeter::NUMERIC)
		{
			mystate.measurelength = TYPE_DURATION (grmeter->getNumerator(),
				grmeter->getDenominator());
		}
		mystate.nextmeasuretime = grmeter->getRelativeTimePosition()
			+ mystate.measurelength;
			*/
	} 
	//else
	//	mystate.measurelength = TYPE_DURATION(-1L); 
		
}
void GRStaff::setClefParameters(GRClef *grclef,GRStaffState::clefstate cstate)
 {
 mystate.clefset = cstate;
 if (grclef == NULL)
	{ // Standard ...
	mystate.curclef = NULL;
	mystate.clefname = "";
	mystate.basepit = NOTE_G + mystate.basepitoffs;
	mystate.baseoct = 1;
	mystate.octava = 0;
	mystate.baseline = 3;
	avg_position = 0.0;
	note_count = 0;
	}
  else
	{ // Standard ...
	ARClef *aclef = dynamic_cast<ARClef *>(grclef->getAbstractRepresentation());
	mystate.curclef = aclef;
	mystate.clefname = aclef->getName();
	mystate.basepit = grclef->getBasePitch() + mystate.basepitoffs;
	mystate.baseoct = grclef->getBaseOct();
	mystate.octava = 0;
	mystate.baseline = grclef->getBaseLine();
	}


  // now we have to take into consideration the 
  // instrument-offset (e.g. "clarinet in A")
  // which changes the basepitch ....
  // (relative to the "normal" C-Major oriented scale)


 }

void GRStaff::setKeyParameters(GRKey *key)
{
	// setzt das aktuelle Vorzeichen ...
	if (key == NULL)
	{
		mystate.curkey = NULL;
		mystate.keyset = 0;
		mystate.numkeys = 0;
		for (int i=0;i<NUMNOTES;i++)
		{
			mystate.VorzeichenArray[i] = -(mystate.instrKeyArray[i]);
			mystate.KeyArray[i] = 0;
		}
		
	 }
	 else
	 {
		mystate.keyset = 1;
		mystate.curkey = dynamic_cast<ARKey *>(
			key->getAbstractRepresentation());
		mystate.numkeys = key->getKeyArray(mystate.KeyArray);
		for (int i=0;i<NUMNOTES;i++)
			mystate.VorzeichenArray[i] = mystate.KeyArray[i] -
					mystate.instrKeyArray[i];
	 }
}

void GRStaff::setNoteParameters(GRNote *note)
{
	// Hier muss der aktuelle Key getestet werden!
	if (note == NULL)
	  {
//	  for (int i=0;i<NUMNOTES;i++)
//		 mystate.VorzeichenArray[i] = 0;
	  return;
	  }

	// Mache eine Schluesselanalyse
	if (mystate.clefset == GRStaffState::CLEFAUTO)
	  {
	  avg_position += note->getPosition().y;
	  note_count++;
	  }

	// Reset der Vorzeichen ...
	ARNote *arnote = note->getARNote();
	int tmppitch = arnote->getPitch();

	mystate.VorzeichenArray[tmppitch - NOTE_C] =
			arnote->getAccidentals() -
			mystate.instrKeyArray[tmppitch - NOTE_C];
}


COLORREF GRStaff::getNoteColor(TYPE_PITCH pit)  const
{
	if (pit>= NOTE_C && pit<= NOTE_H)
		return (RGB(0,0,0)); // SCHWARZ
	if (pit>= NOTE_CIS && pit <= NOTE_AIS)
		return (RGB(0,0,255)); // Blau
	return (RGB(255,0,0)); // Rot
}

long GRStaff::getKeyPosition(TYPE_PITCH pit,int numkeys) const
{

	// this algorithm works as follows:
	// 1. we check, whether we have a treble or a bass-clef
	//    if yes, the upperbound and lowerbound is
	//    determined (g# for sharps and f& for flats)
	// if not, we determine the upperbound for the
	// topmost not within the system for sharps or
	// the bottombound for the lowest note for flats.


	int topbound;
	int bottombound;
	if ((mystate.basepit - mystate.basepitoffs == NOTE_G
		&& mystate.baseline == 3 )
		||
		(mystate.basepit - mystate.basepitoffs == NOTE_F
		&& mystate.baseline == 1 ) )
	{   // treble- or bass-clef
		
		
		// flats ?
		if (numkeys<0)
		{
			// determine lowerbound
			int baseoct = mystate.baseoct-1;
			do
			{
				bottombound = getNotePosition( NOTE_F, baseoct);
				baseoct++;
			}
			while (bottombound > (mystate.numlines)*getStaffLSPACE() );
			// Watch it here: the f-flat can be just outside
			// (below lowest line)
		}
		else
		{
			// sharps
			int baseoct = mystate.baseoct+1;
			do
			{
				topbound = getNotePosition( NOTE_G, baseoct);
				baseoct--;
			}
			while (topbound < -getStaffLSPACE());
			// The g-sharp can be just above the 
			// top-line
			
		} 
	}
	else 
	{
		
		// we have another clef ...

		// find out the topmost and the bottommost note
		int topnote = (( (mystate.basepit-NOTE_C) + 
			(mystate.baseline * 2) ) 
			% 7 ) + NOTE_C;
		int bottomnote = (  (mystate.basepit-NOTE_C) -
			(long) (mystate.numlines - 1 - mystate.baseline)*2 
			% 7);
		if (bottomnote<0)
			bottomnote += 7;
		bottomnote += NOTE_C;

		// now find the positions for the notes.
		int baseoct = mystate.baseoct+1;
		do
		{
			topbound = getNotePosition(topnote,baseoct);
			baseoct--;
		}
		while (topbound< 0);
		// The note must lie completly within the system.

		baseoct = mystate.baseoct                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            